/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.PlantuneDllApiException;
import com.google.common.base.Strings;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.tab.csv.CsvSettings;
import cz.insophy.inplan.tab.csv.CsvsLoader;
import cz.insophy.inplan.tab.csv.CsvsWriter;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.errlog.ErrorLog;
import cz.insophy.inplan.xml.SuperplanSerializer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import log.Logging;
import ptqi.DataOutExporter;
import ptqi.DataSrcImporter;
import ptqi.Planner;
import ptqi.model.Parameter;

public class PlantuneDllApi {
    protected static final Charset CHARSET;
    private final ConcurrentMap<String, byte[]> storage;
    private final AtomicReference<byte[]> lastError;
    private final AtomicInteger lastErrorCode;
    private final Lock l = new ReentrantLock();
    private PlantuneRun activeRun;
    private Thread activeThread;
    private int runCnt;

    public PlantuneDllApi() {
        this.storage = new ConcurrentHashMap<String, byte[]>();
        this.lastError = new AtomicReference<byte[]>(new byte[0]);
        this.lastErrorCode = new AtomicInteger(0);
        CsvSettings.switchToDllSettings();
    }

    public boolean putData(byte[] name, ByteBuffer dataBuf) {
        return this.catchExceptions(() -> {
            byte[] data = new byte[dataBuf.capacity()];
            dataBuf.get(data);
            this.storage.put(PlantuneDllApi.toS(name), data);
        });
    }

    public boolean putDataFromFile(byte[] name, byte[] filename) {
        return this.catchExceptions(() -> this.storage.put(PlantuneDllApi.toS(name), Files.readAllBytes(Paths.get(PlantuneDllApi.toS(filename), new String[0]))));
    }

    public int getDataLen(byte[] name) {
        int[] res = new int[]{-1};
        this.catchExceptions(() -> {
            byte[] data = this.getDataCheck(name);
            res[0] = data.length;
        });
        return res[0];
    }

    public boolean getData(byte[] name, ByteBuffer dataBuf) {
        return this.catchExceptions(() -> {
            byte[] data = this.getDataCheck(name);
            dataBuf.put(data, 0, Math.min(dataBuf.capacity(), data.length));
        });
    }

    public boolean getDataToFile(byte[] name, byte[] filename) {
        return this.catchExceptions(() -> {
            byte[] data = this.getDataCheck(name);
            try (FileChannel ch = FileChannel.open(Paths.get(PlantuneDllApi.toS(filename), new String[0]), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                ch.write(ByteBuffer.wrap(data));
            }
        });
    }

    private byte[] getDataCheck(byte[] name) throws PlantuneDllApiException {
        byte[] data = (byte[])this.storage.get(PlantuneDllApi.toS(name));
        if (data == null) {
            throw new PlantuneDllApiException("Unknown data name " + PlantuneDllApi.toS(name), PlantuneDllApiException.Code.UNKNOWN_DATA_NAME);
        }
        return data;
    }

    public void clearData() {
        try {
            this.storage.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void free() {
    }

    public boolean run() {
        return this.catchExceptions(() -> {
            this.l.lock();
            try {
                if (this.activeThread != null) {
                    throw new PlantuneDllApiException("Only one planning can be run at a time.", PlantuneDllApiException.Code.ALREADY_RUNS);
                }
                PlantuneRun ptRun = new PlantuneRun();
                Thread thread = new Thread((Runnable)ptRun, "Plantune Run " + this.runCnt++);
                thread.start();
                this.activeRun = ptRun;
                this.activeThread = thread;
            }
            finally {
                this.l.unlock();
            }
        });
    }

    public int getState() {
        PlantuneRun run;
        this.l.lock();
        try {
            run = this.activeRun;
        }
        finally {
            this.l.unlock();
        }
        if (run != null) {
            return run.getState();
        }
        this.storeLastError("No run has been started yet.");
        return -3;
    }

    public boolean cancel() {
        return this.catchExceptions(() -> {
            Thread t;
            this.l.lock();
            try {
                t = this.activeThread;
            }
            finally {
                this.l.unlock();
            }
            if (t == null) {
                throw new PlantuneDllApiException("There is no run to cancel.", PlantuneDllApiException.Code.CANNOT_CANCEL);
            }
            t.interrupt();
            t.join();
        });
    }

    private boolean catchExceptions(VoidCallable callable) {
        try {
            callable.call();
            return true;
        }
        catch (Throwable e) {
            this.storeLastError(e);
            return false;
        }
    }

    private void storeLastError(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, CHARSET));
        t.printStackTrace(pw);
        pw.flush();
        this.lastError.set(baos.toByteArray());
        if (t instanceof PlantuneDllApiException) {
            this.lastErrorCode.set(((PlantuneDllApiException)t).getErrorCode());
        } else {
            this.lastErrorCode.set(PlantuneDllApiException.Code.GENERIC.errorCode);
        }
    }

    private void storeLastError(String s2) {
        this.lastError.set(PlantuneDllApi.toB(s2));
    }

    public int getErrorLen() {
        return this.lastError.get().length;
    }

    public void getError(ByteBuffer dest) {
        try {
            byte[] le = this.lastError.get();
            dest.put(le, 0, Math.min(dest.capacity(), le.length));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getErrorCode() {
        return this.lastErrorCode.get();
    }

    private static String toS(byte[] b) {
        return new String(b, CHARSET);
    }

    private static byte[] toB(String s2) {
        return s2.getBytes(CHARSET);
    }

    static {
        Logging.init();
        Localizer.addResourceBundle("Messages");
        Localizer.addResourceBundle("ptqi.Messages");
        CHARSET = System.getProperty("os.name").toLowerCase().contains("win") ? StandardCharsets.UTF_16LE : Charset.forName("UTF-32LE");
    }

    private static interface VoidCallable {
        public void call() throws Exception;
    }

    private class PlantuneRun
    implements Runnable {
        private final AtomicInteger progress;
        private final ErrorLog errorLog = new ErrorLog();
        private boolean dumpData;
        private Path dumpDataDir;

        PlantuneRun() {
            this.progress = new AtomicInteger(0);
        }

        private void initDebugMode(CsvsLoader loader) {
            try {
                this.dumpData = false;
                this.dumpDataDir = null;
                for (Parameter p : loader.load(Parameter.class)) {
                    if (!"DEBUG".equalsIgnoreCase(p.name)) continue;
                    this.dumpData = true;
                    Path baseDir = Strings.isNullOrEmpty(p.value) ? Paths.get(System.getProperty("java.io.tmpdir"), new String[0]) : Paths.get(p.value, new String[0]);
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
                    this.dumpDataDir = baseDir.resolve("plantune-run_" + LocalDateTime.now(ZoneId.systemDefault()).format(formatter));
                    Files.createDirectories(this.dumpDataDir, new FileAttribute[0]);
                    break;
                }
            }
            catch (Exception e) {
                if (this.dumpData) {
                    this.errorLog.add(5, "error.save.init", "msg", e.getMessage(), "path", this.dumpDataDir);
                }
                this.dumpData = false;
            }
        }

        private void dumpPlan(String name, Superplan superplan) {
            if (!this.dumpData) {
                return;
            }
            Path planPath = this.dumpDataDir.resolve(name + ".zip");
            try {
                SuperplanSerializer.storeToZip(superplan, planPath.toFile());
            }
            catch (Exception e) {
                this.errorLog.add(5, "error.save.plan", "msg", e.getMessage(), "path", planPath);
            }
        }

        private void dumpStorage(String prefix) {
            if (!this.dumpData) {
                return;
            }
            Path zipFile = this.dumpDataDir.resolve(prefix + ".zip");
            try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(zipFile, new OpenOption[0])));){
                List<String> filenames = PlantuneDllApi.this.storage.keySet().stream().filter(s2 -> s2.regionMatches(true, 0, prefix, 0, prefix.length())).sorted().toList();
                for (String fn : filenames) {
                    byte[] data = (byte[])PlantuneDllApi.this.storage.get(fn);
                    if (data == null) continue;
                    zos.putNextEntry(new ZipEntry(fn + ".csv"));
                    zos.write(data);
                }
            }
            catch (Exception e) {
                this.errorLog.add(5, "error.save.storage", "msg", e.getMessage(), "prefix", prefix, "path", zipFile.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.progress.set(0);
                Instant fixationTime = ZonedDateTime.now(ZoneId.systemDefault()).truncatedTo(ChronoUnit.SECONDS).toInstant();
                CsvsLoader loader = CsvsLoader.fromMap(PlantuneDllApi.this.storage, this.errorLog);
                this.initDebugMode(loader);
                this.dumpStorage("data_src");
                DataSrcImporter importer = new DataSrcImporter(loader, this.errorLog, fixationTime);
                Superplan superplan = importer.createEmptySuperplan();
                this.dumpPlan("empty", superplan);
                this.checkInterrupted();
                this.progress.set(20);
                Planner planner = new Planner(superplan, this.errorLog);
                planner.addProgressListener(p -> this.progress.set(20 + (int)(70.0 * p)));
                planner.run();
                this.checkInterrupted();
                this.progress.set(90);
                this.dumpPlan("planned", superplan);
                CsvsWriter csvsWriter = CsvsWriter.toMap(PlantuneDllApi.this.storage);
                DataOutExporter exporter = new DataOutExporter(csvsWriter, superplan, this.errorLog);
                exporter.exportPlanData();
                exporter.exportErrorLog();
                this.dumpStorage("data_out");
                this.progress.set(100);
                System.out.println(Thread.currentThread().getName() + ": done");
            }
            catch (InterruptedException e) {
                this.progress.set(-2);
            }
            catch (Throwable e) {
                PlantuneDllApi.this.storeLastError(e);
                this.progress.set(-1);
            }
            finally {
                PlantuneDllApi.this.l.lock();
                try {
                    PlantuneDllApi.this.activeThread = null;
                }
                finally {
                    PlantuneDllApi.this.l.unlock();
                }
            }
        }

        private void checkInterrupted() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }

        int getState() {
            return this.progress.get();
        }
    }
}

